unit KompasAPI;

interface

uses ComObj, OleCtrls, ksTLB, Classes, SysUtils, Forms, Controls;

TYPE TPartVar=RECORD
      VarName:STRING;
      VarNote:STRING;
      VarValue:REAL
     END;
     TPartVars=ARRAY OF TPartVar;

VAR
  kompas:KompasObject;
  Doc:ksDocument3D;
  KompasHandle:THandle;
  prt:TStringList; //   
  partvar:TPartVars;

function StartKompas(filename:string):boolean;
procedure ReadParts(s:TStringList);
function GetPartVars(partname:STRING):TPartVars;
PROCEDURE ChangeVar(partname, varname: STRING; value_:REAL);

implementation

function StartKompas(filename:string):boolean;

const ka='Kompas.Application.5';

begin
//    3D
 Screen.Cursor:=crHourGlass;
 Result:=true;
 try
 kompas:=KompasObject(GetActiveOleObject(ka)); //   
 except
   try
    kompas:=KompasObject(CreateOleObject(ka)); //   
   except
    result:=false;
    Screen.Cursor:=crDefault;
    exit;
   end
  end;
  //     
  KompasHandle := kompas.ksGetHWindow;
  //    
  kompas.Visible:=true;
  //      
  Doc := ksDocument3D(kompas.ActiveDocument3D);
  //    ...
  if Assigned(Doc) then
   //   
   Doc.close;
  //   ...
  Doc := ksDocument3D(kompas.Document3D);
  //        filename
  Doc.Open(Trim(filename), False);
  //  API
  kompas.ActivateControllerAPI;
  Screen.Cursor:=crDefault
end;


PROCEDURE ChangeVar(partname, varname: STRING; value_:REAL);

VAR vr:ksVariableCollection;
    parts:ksPartCollection;
    part:ksPart;
    vvv:ksVariable;

BEGIN
 //  
 parts:=ksPartCollection(doc.PartCollection(true));
 //    
 part:=kspart(parts.GetByName(partname,true,true));
 //   
 vr:=ksVariableCollection(part.VariableCollection);
 //    
 vvv:=ksVariable(vr.GetByName(varname,true,true));
 //   
 part.BeginEdit;
 //  
 vvv.value:=value_;
 //  
 part.Update;
 part.RebuildModel;
 //      
 part.EndEdit(true);
 //  
 parts.refresh
END;

function GetPartVars(partname:STRING):TPartVars;

var vr:ksVariableCollection;
    parts:ksPartCollection;
    part:ksPart;
    univar:ksVariable;
    j, numpart:WORD;

begin
  parts:=ksPartCollection(doc.PartCollection(true));
  //      partname
  part:=ksPart(parts.GetByName(partname,True,True));
  if part=nil then
   begin
    SetLength(result,0);
    exit
   end;
  //     
  vr:=ksVariableCollection(part.VariableCollection);
  //    
  numpart:=vr.GetCount;
  SetLength(result,numpart);
  for j:=0 to numpart-1 do
     begin
      //    
      univar:=ksVariable(vr.GetByIndex(j));
      with result[j] do
       begin
        VarName:=univar.name;
        VarValue:=univar.value;
        VarNote:=univar.note
       end
     end
end;

procedure ReadParts(s:TStringList);

var i,num:word;
    parts:ksPartCollection;
    part:ksPart;
begin
  //   
  parts:=ksPartCollection(doc.PartCollection(true));
  num:=parts.GetCount;
  s.Clear;
  s.Add(ksPart(doc.GetPart(-1)).name);
  for i:=0 to num-1 do
   begin
    part:=ksPart(parts.GetByIndex(i));
    s.Add(part.name);
   end
end;


initialization

begin
 prt:=TStringList.Create;
 SetLength(partvar,0)
end;

finalization

begin
 finalize(partvar);
 prt.Free
end;

end.


