unit calc;

interface

uses math, parser, classes, grids, KompasAPI, ComCtrls;

type
    TAngleFormat=(RADIANS,DEGREES);
    TCalc=class
      private
       lexlist:TLexemList;
       lexnum:word;
       err:string;
       vrs:TTreeView;
       function GetError:string;
       function MathExpr:Extended;
       function Func:Extended;
       function GetVarValue:Extended;
       function Base:Extended;
       function Factor:Extended;
       function Term:Extended;
       function GetLex:TLexeme;
       procedure NextLex;
      public
       AngleFormat:TAngleFormat;
       function Evaluate(ll:TLexemList):string;
       constructor Create(sv:TTreeView);
       property error:string read GetError;
      end;

implementation

uses sysutils;

{ }

function TCalc.GetLex:TLexeme;

begin
 Result:=LexList[lexnum]
end;

procedure TCalc.NextLex;

begin
 inc(lexnum)
end;

constructor TCalc.Create(sv:TTreeView);

begin
 inherited Create;
 SetLength(LexList,0);
 lexnum:=0;
 AngleFormat:=RADIANS;
 vrs:=sv;
 err:=''
end;

function TCalc.GetError:string;

begin
 Result:=err
end;

function TCalc.Func:Extended;
 var FuncName:TLexemeType;
     Arg:Extended;
  begin
   FuncName:=GetLex.LexemeType;
   NextLex;
   if GetLex.LexemeType<>ltLeftBracket then
    begin
     err:=' "("   '+IntToStr(GetLex.Pos);
     exit
    end;
   NextLex;
   Arg:=MathExpr;
   if GetLex.LexemeType<>ltRightBracket then
    begin
     err:=' ")"   '+IntToStr(GetLex.Pos);
     exit
    end;
   NextLex;
   case FuncName of
    ltSin: if angleformat=radians then
             Result:=Sin(Arg)
            else
             Result:=Sin(DegToRad(Arg));
    ltCos:if angleformat=radians then
             Result:=Cos(Arg)
            else
             Result:=Cos(DegToRad(Arg));
    ltLn:Result:=Ln(Arg);
    ltabs:Result:=abs(Arg);
    ltSQRT:Result:=SQRT(Arg)
   else
    begin
     err:='    Func';
     exit
    end
   end
  end;

function TCalc.GetVarValue:Extended;

var i:WORD;
    n:STRING;

begin
 FOR i:=0 TO Vrs.Items.Count-1 DO
  IF Vrs.Items[i].Level=2 THEN
   BEGIN
    n:=ansiuppercase(Vrs.Items[i].Text);
    if pos('(',n)>0 then
     n:=trim(copy(n,1,pos('(',n)-1));
    IF n=ansiuppercase(trim(GetLex.Lexeme)) then
      begin
       Result:=StrToFloat(Vrs.Items[i].GetFirstChild.Text);
       exit
      end
     END;
   err:='  '+GetLex.Lexeme+'   '+IntToStr(GetLex.Pos)
  end;

function TCalc.Base:Extended;
 begin
  case GetLex.LexemeType of
   ltLeftBracket:
    begin
     NextLex;
     Result:=MathExpr;
     if GetLex.LexemeType<>ltRightBracket then
      begin
       err:=' ")"   '+IntToStr(GetLex.Pos);
       exit
      end;
     NextLex
    end;
   ltSin,ltCos,ltLn,ltSQRT,ltABS:
    Result:=Func;
   ltIdentifier:
    begin
     Result:=GetVarValue;
     if err<>'' then
      exit;
     NextLex
    end;
   ltNumber:
    begin
     Result:=StrToFloat(GetLex.Lexeme);
     NextLex
    end
   else
    err:='    '+IntToStr(GetLex.Pos)
  end
 end;

function TCalc.Factor:Extended;
 begin
  case GetLex.LexemeType of
   ltPlus:
    begin
     NextLex;
     Result:=Factor
    end;
   ltMinus:
    begin
     NextLex;
     Result:=-Factor
    end;
   ltNot:
    begin
     NextLex;
     Result:=not Trunc(Factor)
    end
   else
    begin
     Result:=Base;
     if GetLex.LexemeType=ltCap then
      begin
       NextLex;
       Result:=Power(Result,Factor)
      end
    end
  end
 end;

function TCAlc.Term:Extended;
 var Operator:TLexemeType;
  begin
   Result:=Factor;
   while (GetLex.LexemeType in Operator2) do
    begin
     Operator:=GetLex.LexemeType;
     NextLex;
     case Operator of
      ltAsterisk:Result:=Result*Factor;
      ltSlash:Result:=Result/Factor;
      ltDiv:Result:=Trunc(Result) div Trunc(Factor);
      ltMod:Result:=Trunc(Result) mod Trunc(Factor);
      ltAnd:Result:=Trunc(Result) and Trunc(Factor)
     end
    end
  end;

// 
function TCalc.MathExpr:Extended;
 var Operator:TLexemeType;
  begin
   Result:=Term;
   while GetLex.LexemeType in Operator1 do
    begin
     Operator:=GetLex.LexemeType;
     NextLex;
     case Operator of
      ltPlus:Result:=Result+Term;
      ltMinus:Result:=Result-Term;
      ltOr:Result:=Trunc(Result) or Trunc(Term);
      ltXor:Result:=Trunc(Result) xor Trunc(Term)
     end
    end
  end;


//  
function TCalc.Evaluate(ll:TLexemList):string;
 var Res1:Extended;
     Operator:TLexemeType;
     i:word;

  function GetBoolStr(Res:Boolean):string;
  const r:array[false..true] of string[5]=
  ('False','True');
   begin
    Result:=r[res]
   end;

   begin
     lexlist:=ll;
     Res1:=MathExpr;
     if GetLex.LexemeType in Comparison then
      begin
       Operator:=GetLex.LexemeType;
       NextLex;
       case Operator of
        ltEqual:Result:=GetBoolStr(Res1=MathExpr);
        ltLess:Result:=GetBoolStr(Res1<MathExpr);
        ltGreater:Result:=GetBoolStr(Res1>MathExpr);
        ltLessOrEqual:Result:=GetBoolStr(Res1<=MathExpr);
        ltGreaterOrEqual:Result:=GetBoolStr(Res1>=MathExpr);
        ltNotEqual:Result:=GetBoolStr(Res1<>MathExpr)
       end
      end
     else
      Result:=FloatToStr(Res1);
     if (GetLex.LexemeType<>ltEnd) and (err='') then
      err:='    '+IntToStr(GetLex.Pos);
   SetLEngth(lexlist,0);
   lexnum:=0
  end;

end.
