unit main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComObj, OleCtrls, ksTLB, ExtCtrls, ComCtrls, ImgList, KompasAPI, calc, parser,
  DB, DBTables, Grids, DBGrids, DBCtrls;

type
  TForm1 = class(TForm)
    LabeledEdit1: TLabeledEdit;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    StatusBar1: TStatusBar;
    ImageList1: TImageList;
    Table1: TTable;
    Table1ID: TAutoIncField;
    Table1Expression: TStringField;
    Panel1: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Button1: TButton;
    Button3: TButton;
    TreeView1: TTreeView;
    DataSource1: TDataSource;
    DBNavigator1: TDBNavigator;
    DBGrid1: TDBGrid;
    procedure Button1Click(Sender: TObject);
    procedure LabeledEdit1Change(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TreeView1Changing(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure TreeView1Edited(Sender: TObject; Node: TTreeNode;
      var S: String);
    procedure TreeView1Editing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure Button3Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  oldv:string='';
  ch:ARRAY OF WORD;
  Lx:TLexicalAnalyzer;
  Cl:TCalc;

implementation

{$R *.dfm}

procedure LoadVars;

var top,vrr,vrr1,vrr2:TTreeNode;
    i,j:word;

begin
  form1.TreeView1.Items.Clear;
  top:=form1.TreeView1.Items.AddChild(nil,ksPart(doc.GetPart(-1)).name);
  top.ImageIndex:=0;
  //   
  for i:=1 to prt.Count-1 do
   begin
    //   
    partvar:=GetPartVars(prt[i]);
    vrr:=form1.TreeView1.Items.AddChild(top,prt[i]);
    vrr.ImageIndex:=1;
    //    
    for j:=0 to length(partvar)-1 do
     begin
      vrr1:=form1.TreeView1.Items.AddChild(vrr,partvar[j].VarName);
      if partvar[j].VarNote<>'' then
       vrr1.Text:=vrr1.Text+'('+partvar[j].VarNote+')';
      vrr1.ImageIndex:=2;
      vrr2:=form1.TreeView1.Items.AddChild(vrr1,FloatToStr(partvar[j].VarValue));
      vrr2.ImageIndex:=3;
      vrr2.SelectedIndex:=4
     end;
    end;
    form1.TreeView1.FullExpand
end;

procedure Modify;

var i:word;
    node,node1:TTreeNode;
    varname:STRING;

begin
 for i:=0 to length(ch)-1 do
  with form1.TreeView1 do
   begin
    node:=Form1.TreeView1.Items[ch[i]];
    node1:=node.Parent;
    varname:=node1.Text;
    if pos('(',varname)>0 then
     varname:=trim(copy(varname,1,pos('(',varname)-1));
    //  node1.parent.text -  
    ChangeVar(node1.Parent.Text,varname,StrToFloat(node.Text))
   end
end;


procedure TForm1.Button1Click(Sender: TObject);

begin
 if not(StartKompas(Trim(LabeledEdit1.Text))) then
  begin
   messagedlg('   ',mtError,[mbOK],0);
   exit
  end;
  statusbar1.SimpleText:=Trim(LabeledEdit1.Text);
  ReadParts(prt);
  LoadVars
end;

procedure TForm1.LabeledEdit1Change(Sender: TObject);
begin
 button1.Enabled:=FileExists(Trim(labelededit1.Text))
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 WITH OpenDialog1 DO
  IF Execute THEN
   LabeledEdit1.Text:=FileName
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
 OpenDialog1.InitialDir:=ExtractFileName(Application.ExeName);
 SetLength(ch,0);
 Lx:=TLexicalAnalyzer.Create;
 Cl:=Tcalc.Create(TreeView1);
 WITH Table1 DO
  BEGIN
    DataBaseName:=ExtractFilePath(Application.ExeName);
    Open
  END
end;

procedure TForm1.TreeView1Changing(Sender: TObject; Node: TTreeNode;
  var AllowChange: Boolean);
begin
 AllowChange:=Node.Level=3
end;

procedure TForm1.TreeView1Edited(Sender: TObject; Node: TTreeNode;
  var S: String);
begin
 try
  strtofloat(s)
 except
  MessageDlg(s+' -   ',
  mtError,[mbOK],0);
  s:=oldv;
  abort
 end;
 SetLEngth(ch,Length(ch)+1);
 ch[length(ch)-1]:=node.AbsoluteIndex;
 Button3.Enabled:=true
end;

procedure TForm1.TreeView1Editing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
 oldv:=treeview1.Selected.Text;
 AllowEdit:=true
end;

function CheckVars:boolean;

VAR r:STRING;

begin
 Result:=true;
 WITH Form1.Table1 DO
  BEGIN
   First;
   WHILE NOT(EOF) DO
    BEGIN
     //  
     Lx.Parse(Form1.Table1Expression.AsString);
     IF Lx.error<>'' THEN
      BEGIN
       MessageDlg('   '+IntToStr(RecNo)+' :'+#13+
       Lx.error,mtError,[mbOK],0);
       Result:=FALSE;
       Exit
      END;
      //  
      r:=Cl.Evaluate(Lx.LexemList);
      IF Cl.error<>'' THEN
      BEGIN
       MessageDlg('   '+IntToStr(RecNo)+' :'+#13+
       Cl.error,mtError,[mbOK],0);
       Result:=FALSE;
       Exit
      END;
     IF ANSIUpperCase(r)<>'TRUE' THEN
      BEGIN
       MessageDlg('  '+#13+
       Form1.Table1Expression.AsString,mtError,[mbOK],0);
       Result:=FALSE;
       Exit
      END;
     Next
    END
   END
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 Screen.Cursor:=crHourGlass;
 if not(CheckVars) then
  begin
    Screen.Cursor:=crDefault;
    abort
  end;
 Modify;
 doc.Save;
 button3.Enabled:=false;
 SetLength(ch,0);
 Screen.Cursor:=crDefault
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Lx.Free;
 Cl.Free;
 WITH Table1 DO
  IF Active THEN
   Close
end;

end.
