unit parser;

interface

uses sysutils;

type TLexemeType=(ltEqual,ltLess,ltGreater,ltLessOrEqual,ltGreaterOrEqual,ltNotEqual,
                  ltPlus,ltMinus,ltOr,ltXor,
                  ltAsterisk,ltSlash,ltDiv,ltMod,ltAnd,
                  ltNot,
                  ltCap,
                  ltLeftBracket,ltRightBracket,
                  ltSin,ltCos,ltLn,ltSQRT,ltABS,
                  ltIdentifier,
                  ltNumber,
                  ltEnd);

     TLexeme=record
              LexemeType:TLexemeType;
              Pos:Integer;
              Lexeme:string
             end;

     TLexemList=array of TLExeme;

     TError=(NONE,UNCLOSED_COMMENT,WRONG_CHAR);

     TLexicalAnalyzer=class
                       private
                        FLexemeList:TLexemList;
                        FIndex:Integer;
                        err:TError;
                        function GetLexeme:TLexeme;
                        procedure SkipWhiteSpace(const S:string;var P:Integer);
                        procedure ExtractLexeme(const S:string;var P:Integer);
                        procedure PutLexeme(NewLexemeType:TLexemeType;NewPos:Integer;NewLexeme:string);
                        procedure Number(const S:string;var P:Integer);
                        procedure Word(const S:string;var P:Integer);
                        function GetLExemList:TLexemList;
                        function GetError:string;
                       public
                        constructor Create;
                        procedure Parse(const Expr:string);
                        destructor Free;
                        property Lexeme:TLexeme read GetLexeme;
                        property LexemList:TLExemList read GetLExemList;
                        property error:string read GetError;
                      end;

const Comparison=[ltEqual,ltLess,ltGreater,ltLessOrEqual,ltGreaterOrEqual,ltNotEqual];
      Operator1=[ltPlus,ltMinus,ltOr,ltXor];
      Operator2=[ltAsterisk,ltSlash,ltDiv,ltMod,ltAnd];

implementation

{TLexicalAnalyzer}

procedure  TLexicalAnalyzer.Parse(const Expr:string);
 var P:Integer;
  begin
   SetLength(FLexemeList,0);
   P:=1;
   err:=NONE;
   while (P<=Length(Expr)) and (err=NONE) do
    begin
     SkipWhiteSpace(Expr,P);
     ExtractLexeme(Expr,P)
    end;
   PutLexeme(ltEnd,P,'');
   FIndex:=0
  end;

function TLExicalAnalyzer.GetLExemList:TLexemList;

begin
 Result:=self.FLexemeList
end;


constructor TLexicalAnalyzer.Create;

  begin
   inherited Create;
   SetLength(FLexemeList,0);
   err:=NONE;
  end;

function TLexicalAnalyzer.GetError:string;

const errmes:array[NONE..WRONG_CHAR] of string=
('',' ',' ');

begin
 Result:=errmes[err]
end;

destructor TLexicalAnalyzer.Free;

begin
 Finalize(FLexemeList)
end;

function TLexicalAnalyzer.GetLexeme:TLexeme;
 begin
  Result:=FLexemeList[FIndex]
 end;

procedure TLexicalAnalyzer.PutLexeme(NewLexemeType:TLexemeType;NewPos:Integer;NewLexeme:string);

begin
 SetLength(FlexemeList,LEngth(FlexemeList)+1);
 with FLexemeList[Length(FLExemeList)-1] do
 begin
  LexemeType:=NewLexemeType;
  Pos:=NewPos;
  Lexeme:=NewLexeme
 end
end;

//  ,  ,    ,
//            
procedure TLexicalAnalyzer.SkipWhiteSpace(const S:string;var P:Integer);
 begin
  while (P<=Length(S)) and (S[P] in [' ',#9,#13,#10,'{']) do
   if S[P]='{' then
    begin
     Inc(P);
     while (P<=Length(S)) and (S[P]<>'}') do
      Inc(P);
     if P>Length(S) then
      begin
       err:=UNCLOSED_COMMENT;
       exit
      end;
     Inc(P)
    end
   else
    Inc(P)
 end;

//         
procedure TLexicalAnalyzer.ExtractLexeme(const S:string;var P:Integer);

const ids:array[1..8] of TLexemeType=
                  (ltEqual, ltCap,
                  ltPlus,ltMinus,
                  ltAsterisk,ltSlash,
                  ltLeftBracket,
                  ltRightBracket);

      idnames:array[1..8] of char=
      ('=','^','+','-','*','/','(',')');

var i:byte; found:boolean;

begin
  if P>Length(S) then
   Exit;
  found:=false;
  for i:=1 to 8 do
   if s[p]=idnames[i] then
    begin
     found:=true;
     PutLexeme(ids[i],P,'');
     inc(p)
    end;
  if not(found) then
   case S[P] of
   '0'..'9':
    Number(S,P);
   '<':
    if (P<Length(S)) and (S[P+1]='=') then
     begin
      PutLexeme(ltLessOrEqual,P,'');
      Inc(P,2)
     end
    else if (P<Length(S)) and (S[P+1]='>') then
     begin
      PutLexeme(ltNotEqual,P,'');
      Inc(P,2)
     end
    else
     begin
      PutLexeme(ltLess,P,'');
      Inc(P)
     end;
   '>':
    if (P<Length(S)) and (S[P+1]='=') then
     begin
      PutLexeme(ltGreaterOrEqual,P,'');
      Inc(P,2)
     end
    else
     begin
      PutLexeme(ltGreater,P,'');
      Inc(P)
     end;
   'A'..'Z','a'..'z','_':
    Word(S,P);
   else
    err:=WRONG_CHAR
  end
 end;

procedure TLexicalAnalyzer.Number(const S:string;var P:Integer);
 var InitPos,RollbackPos:Integer;

  function IsDigit(Ch:Char):Boolean;
   begin
    Result:=Ch in ['0'..'9']
   end;

   begin
    InitPos:=P;
    repeat
     Inc(P)
    until (P>Length(S)) or not IsDigit(S[P]);
    if (P<=Length(S)) and (S[P]=DecimalSeparator) then
     begin
      Inc(P);
      if (P>Length(S)) or not IsDigit(S[P]) then
       Dec(P)
      else
       repeat
        Inc(P)
       until (P>Length(S)) or not IsDigit(S[P]);
     end;
    if (P<=Length(S)) and (UpCase(S[P])='E') then
     begin
      RollBackPos:=P;
      Inc(P);
      if P>Length(S) then
       P:=RollBackPos
      else
       begin
        if S[P] in ['+','-'] then
         Inc(P);
        if (P>Length(S)) or not IsDigit(S[P]) then
         P:=RollbackPos
        else
         repeat
          Inc(P)
         until (P>Length(S)) or not IsDigit(S[P])
       end
     end;
    PutLexeme(ltNumber,InitPos,Copy(S,InitPos,P-InitPos))
   end;

procedure TLexicalAnalyzer.Word(const S:string;var P:Integer);

const ids:array[1..11] of TLexemeType=
(ltOr,ltXor,ltDiv,ltMod,ltAnd,ltNot,ltSin,ltCos,ltLn,ltSQRT,ltABS);
      idnames:array[1..11] of string[4]=
      ('or','xor','div','mod','and','not','sin','cos','ln','sqrt','abs');

var InitPos:Integer;
    ID:string;
    i:byte;
    found:boolean;

  begin
   found:=false;
   InitPos:=P;
   Inc(P);
   while (P<=Length(S)) and (S[P] in ['0'..'9','A'..'Z','a'..'z','_']) do
    Inc(P);
   ID:=Copy(S,InitPos,P-InitPos);
   for i:=1 to length(ids) do
    if AnsiCompareText(ID,idnames[i])=0 then
     begin
      PutLexeme(ids[i],InitPos,'');
      found:=true
     end;
   if not(found) then
    PutLexeme(ltIdentifier,InitPos,ID)
  end;

end.

